<?php
if (!session_id()) {
    session_start();
}

include_once 'constants.php';

// Change it to login form page
$login_url = filter_var(BASE_URL, FILTER_SANITIZE_URL);

$token = filter_input(INPUT_GET, 'token');

if (empty($token)) {
    die('Token is missing!');
}

$db_connection = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME) OR die(mysqli_connect_error());

// Prepare parameterized query to get user
if (!$stmt = mysqli_prepare($db_connection, 'SELECT id FROM users WHERE token = ?')) {
    die(mysqli_error($db_connection));
}

// Bind params and execute statement
mysqli_stmt_bind_param($stmt, 's', $token);
mysqli_stmt_execute($stmt);

if (!mysqli_stmt_fetch($stmt)) {
    die('Invalid token');
}

mysqli_stmt_close($stmt);

// Prepare parameterized query for update
if (!$stmt = mysqli_prepare($db_connection, 'UPDATE users SET is_verified = 1, token = NULL WHERE token = ?')) {
    die(mysqli_error($db_connection));
}

// Bind params and execute statement
mysqli_stmt_bind_param($stmt, 's', $token);

mysqli_stmt_execute($stmt);
mysqli_stmt_close($stmt);

// Close the connection
mysqli_close($db_connection);

// Set session message and redirect to login page
$_SESSION['flash'] = [
    'message' => 'Account has been successfully verified.'
];

header('Location: ' . $login_url);
exit;