<?php
if (!session_id()) {
    session_start();
}

include_once 'constants.php';

$redirect_back_url = filter_var($_SERVER['HTTP_REFERER'], FILTER_SANITIZE_URL);

// Sanitize input array
$post = filter_input_array(INPUT_POST);

if (!empty($post)) {
    $db_connection = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME) OR die(mysqli_connect_error());

    // Prepare user data variables
    $name = trim($post['name']);
    $email = trim($post['email']);
    $password = password_hash($post['password'], PASSWORD_DEFAULT);
    $token = bin2hex(random_bytes(32));

    // If passwords do not match return back
    if (strcmp($post['password'], $post['password_confirm']) <> 0) {
        $_SESSION['flash'] = [
            'error' => 1,
            'message' => 'Password does not match.'
        ];

        header('Location: ' . $redirect_back_url);
        exit;
    }

    if (!$stmt = mysqli_prepare($db_connection, 'SELECT id FROM users WHERE email = ?')) {
        die(mysqli_error($db_connection));
    }

    mysqli_stmt_bind_param($stmt, 's', $email);

    mysqli_stmt_execute($stmt);

    // If user with email already exists, redirect back with proper alert message
    if ($result = mysqli_stmt_fetch($stmt)) {
        $_SESSION['flash'] = [
            'error' => 1,
            'message' => 'User with email already exists.'
        ];

        header('Location: ' . $redirect_back_url);
        exit;
    }

    mysqli_stmt_close($stmt);

    // Prepare parameterized query
    if (!$stmt = mysqli_prepare($db_connection, 'INSERT INTO users (name, email, password, token) VALUES (?, ?, ?, ?)')) {
        die(mysqli_error($db_connection));
    }

    // Bind parameters to prepared query
    mysqli_stmt_bind_param($stmt, 'ssss', $name, $email, $password, $token);

    // Execute prepared statement
    if (mysqli_stmt_execute($stmt)) {
        $verification_link = BASE_URL . '/verify-registration.php?token=' . $token;

        $subject = 'Account Verification';

        $message = 'Click the link to verify account:' . PHP_EOL;
        $message .= '<a href="' . $verification_link . '">Verify Account</a>';

        $headers = [
            'Content-type' => 'text/html; charset=utf-8',
            'From' => 'no-reply@domain.com'
        ];

        // Send email to user for verification
        mail($post['email'], $subject, $message, $headers);

        $_SESSION['flash'] = [
            'message' => 'Registration successful! Please check your email to verify your account.'
        ];

        // Redirect back with success message
        header('Location: ' . $redirect_back_url);
        exit;
    }

    mysqli_stmt_close($stmt);

    // Close the connection
    mysqli_close($db_connection);
}

// Fallback error message and redirect
$_SESSION['flash'] = [
    'error' => 1,
    'message' => 'Something went wrong! please try again.'
];

header('Location: ' . $redirect_back_url);
exit;