<?php
if (!session_id()) {
    session_start();
}
?>
<!DOCTYPE html>
<html>
    <head>
        <title>Simple User Registration in PHP - Demo</title>
        <meta content="text/html; charset=UTF-8" http-equiv="Content-Type"/>
        <meta content="width=device-width, initial-scale=1, maximum-scale=1" name="viewport"/>
        <link rel="stylesheet" href="css/style.css"/>
    </head>
    <body>
        <section class="section py-4">
            <div class="container">
                <?php if (isset($_SESSION['flash'])) {?>
                    <div class="alert alert-<?=isset($_SESSION['flash']['error']) ? 'red' : 'green';?>">
                        <?=$_SESSION['flash']['message'];?>
                    </div>
                <?php
                    unset($_SESSION['flash']);
                } ?>

                <form class="register-form" method="POST" action="process-register.php">
                    <div class="mb-4">
                        <input type="text" name="name" class="form-control" placeholder="Full name..." required="required"/>
                    </div>

                    <div class="mb-4">
                        <input type="email" name="email" class="form-control" placeholder="Email..." required="required"/>
                    </div>

                    <div class="mb-4">
                        <input type="password" name="password" class="form-control" placeholder="Password..." required="required"/>
                    </div>

                    <div class="mb-4">
                        <input type="password" name="password_confirm" class="form-control" placeholder="Confirm password..." required="required"/>
                    </div>

                    <button type="submit" class="btn btn-green">
                        Register
                    </button>
                </form>
            </div>
        </section>
    </body>
</html>