<?php
if (!session_id()) {
    session_start();
}
?>
<!DOCTYPE html>
<html>
    <head>
        <title>Upload Files to Google Drive in PHP - Demo</title>
        <meta content="text/html; charset=UTF-8" http-equiv="Content-Type"/>
        <meta content="width=device-width, initial-scale=1, maximum-scale=1" name="viewport"/>
        <link rel="stylesheet" href="css/style.css"/>
    </head>
    <body>
        <section class="section py-4">
            <div class="container">
                <?php if (!empty($_SESSION['upload_errors'])) { ?>
                    <div class="alert alert-red">
                        <ul class="errors-list">
                            <?php foreach ($_SESSION['upload_errors'] as $file_error) { ?>
                                <li>
                                    <strong><?= $file_error['file_name']; ?></strong>: <?= $file_error['message']; ?>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                    <?php unset($_SESSION['upload_errors']); ?>
                <?php } ?>

                <?php if (!empty($_SESSION['success'])) { ?>
                    <div class="alert alert-green">
                        File(s) Successfully uploaded.
                    </div>
                    <?php unset($_SESSION['success']); ?>
                <?php } ?>

                <div class="mb-4">
                    <form action="google-drive-file-upload.php" method="POST" enctype="multipart/form-data"
                          class="google-drive-form">
                        <div class="mb-4">
                            <label class="inline-block mb-1">Attach files</label>
                            <input type="file" name="files[]" class="form-control" multiple="multiple"/>
                        </div>
                        <div class="mb-4">
                            <button type="submit" class="btn btn-blue">Upload</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </body>
</html>