<?php
include_once __DIR__ . '/vendor/autoload.php';

if (!session_id()) {
    session_start();
}

$_SESSION['upload_errors'] = [];

// Initialize google client instance
$client = new Google_Client();

// Set service account config
$client->setAuthConfig('PATH_TO_SERVICE_ACCOUNT_CREDENTIALS');

// Set google drive and google drive file scopes
$client->setScopes([Google_Service_Drive::DRIVE, Google_Service_Drive::DRIVE_FILE]);

// Initialize google drive service
$drive = new Google_Service_Drive($client);

for ($i = 0; $i < count($_FILES['files']['name']); $i++) {
    $extension = pathinfo($_FILES['files']['name'][$i], PATHINFO_EXTENSION);

    $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];

    // If file has an upload error, store message in session and continue
    if ($_FILES['files']['error'][$i] !== UPLOAD_ERR_OK) {
        $_SESSION['upload_errors'][] = [
            'file_name' => $_FILES['files']['name'][$i],
            'message' => 'There was an error uploading this file'
        ];

        continue;
    }

    // If file extension is not allowed, store message in session and continue
    if (!in_array(strtolower($extension), $allowed_extensions)) {
        $_SESSION['upload_errors'][] = [
            'file_name' => basename($_FILES['files']['name'][$i]),
            'message' => 'File extension is not allowed'
        ];
        continue;
    }

    // Initialize a Drive File instance
    $drive_file = new Google_Service_Drive_DriveFile();
    $drive_file->setName($_FILES['files']['name'][$i]);
    $drive_file->setParents(['YOUR_GOOGLE_DRIVE_FOLDER_ID']); // Add id of google drive folder

    // Add/Create file on Google Drive
    $file = $drive->files->create($drive_file, [
        'data' => file_get_contents($_FILES['files']['tmp_name'][$i]), // File content
        'mimeType' => mime_content_type($_FILES['files']['tmp_name'][$i]), // Mime type of the file
        'uploadType' => 'multipart', // Upload type
    ]);

    $_SESSION['success'] = true;
}

// Redirect user
header('Location: ' . filter_var($_SERVER['HTTP_REFERER'], FILTER_SANITIZE_URL));
exit;