<!DOCTYPE html>
<html>
    <head>
        <title>RSS Feed Reader in PHP - Demo</title>
        <meta content="text/html; charset=UTF-8" http-equiv="Content-Type"/>
        <meta content="width=device-width, initial-scale=1, maximum-scale=1" name="viewport"/>
        <link rel="stylesheet" href="css/style.css"/>
    </head>
    <body>
        <section class="section py-4">
            <div class="container">
                <?php
                // Define the RSS feed URL
                $rss_feed_url = 'https://www.codestacked.info/feeds/posts/default?alt=rss';

                // Load the RSS feed content using SimpleXML
                $rss = simplexml_load_file($rss_feed_url);

                if ($rss !== false) {
                    ?>
                    <div class="rss-channel">
                        <div class="border bg-light p-4 mb-4">
                            <h1><?= htmlspecialchars($rss->channel->title); ?></h1>
                            <p><?= htmlspecialchars($rss->channel->description); ?></p>
                        </div>

                        <ul class="list-none pl-0">
                            <?php foreach ($rss->channel->item as $item) { ?>
                                <li class="border bg-white mb-4 p-4">
                                    <h2>
                                        <a href="<?= htmlspecialchars($item->link); ?>" rel="nofollow">
                                            <?= htmlspecialchars($item->title); ?>
                                        </a>
                                    </h2>
                                    <div>
                                        <date>
                                            <small><?= date('d-m-Y h:i:s A', strtotime(htmlspecialchars($item->pubDate))); ?></small>
                                        </date>
                                        <div>
                                            <?= strip_tags($item->description, '<div><p><a><img><ul><ol><li><b>'); ?>
                                        </div>
                                    </div>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                <?php } ?>
            </div>
        </section>
    </body>
</html>