<?php
if (!session_id()) {
    session_start();
}

include_once 'constants.php';
include_once 'microsoft-oauth-client.php';

$microsoft_oauth_client = new microsoft_oauth_client(CLIENT_ID, CLIENT_SECRET);

if (isset($_SESSION['access_token'])) {
    $user = $microsoft_oauth_client->get_authenticated_user($_SESSION['access_token']);

    /**
     * YOU CAN STORE USER INFORMATION TO DATABASE HERE
     */
}

$code = filter_input(INPUT_GET, 'code');

if (!empty($code)) {
    $access_token = $microsoft_oauth_client->get_access_token(BASE_URL . 'login-with-microsoft-account-in-php');

    $_SESSION['access_token'] = $access_token;

    header('location: ' . BASE_URL . 'login-with-microsoft-account-in-php');
    exit;
}
?>
<!DOCTYPE html>
<html>
    <head>
        <title>Login with Microsoft Account in PHP - Demo</title>
        <meta content="text/html; charset=UTF-8" http-equiv="Content-Type"/>
        <meta content="width=device-width, initial-scale=1, maximum-scale=1" name="viewport"/>
        <link rel="stylesheet" href="css/style.css"/>
    </head>
    <body>
        <section class="section py-4">
            <div class="container">
                <?php if (isset($_SESSION['access_token'])) { ?>
                    <h3>You are logged in as:</h3>
                    <div class="user-details-container">
                        <div class="user-details">
                            <div>
                                <label>User ID:</label>
                                <span><?= $user->id; ?></span>
                            </div>
                            <div>
                                <label>Name:</label>
                                <span><?= $user->name; ?></span>
                            </div>
                            <div>
                                <a href="logout.php" rel="nofollow">Logout</a>
                            </div>
                        </div>
                    </div>
                <?php } else { ?>
                    <a href="<?= sprintf('https://login.microsoftonline.com/common/oauth2/v2.0/authorize?%s', http_build_query([
                        'client_id' => CLIENT_ID,
                        'response_type' => 'code',
                        'response_mode' => 'query',
                        'scope' => 'openid profile email offline_access User.Read',
                        'redirect_uri' => BASE_URL . 'login-with-microsoft-account-in-php',
                    ])); ?>" class="btn-microsoft" rel="nofollow">
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9.16675 9.1665H2.50008L2.50008 2.49984L9.16675 2.49984V9.1665Z" fill="#FF5722"/>
                            <path d="M17.5 9.1665H10.8333V2.49984L17.5 2.49984V9.1665Z" fill="#4CAF50"/>
                            <path d="M17.5 17.5H10.8333V10.8333H17.5V17.5Z" fill="#FFC107"/>
                            <path d="M9.16675 17.5H2.50008L2.50008 10.8333H9.16675V17.5Z" fill="#03A9F4"/>
                        </svg>

                        <span>Login with Microsoft</span>
                    </a>
                <?php } ?>
            </div>
        </section>
    </body>
</html>