$(document).ready(function () {
    $("#employees-table").dataTable({
        serverSide: true,
        processing: true,
        order: [[0, 'desc']],
        ajax: {
            url: "datatable-ajax.php",
            type: "POST",
            dataType: "json"
        },
        columnDefs: [
            {
                targets: [0, -1],
                orderable: false,
            },
        ],
        columns: [
            {name: "id"},
            {name: "full_name"},
            {name: "email"},
            {name: "gender"},
            {name: "designation"},
            {name: "action"}
        ],
        responsive: {
            breakpoints: [
                {name: 'xxl', width: Infinity},
                {name: 'xl', width: 1200},
                {name: 'lg', width: 992},
                {name: 'md', width: 768},
                {name: 'sm', width: 576},
            ]
        }
    })
});