<?php
include 'constants.php';

$sql = 'SELECT * FROM employees';

$post = filter_input_array(INPUT_POST);

$where = '1=1';

$param_types = '';

$param_values = [];

if (!empty($post['search']['value'])) {
    $where .= ' AND (full_name LIKE ? OR email LIKE ? OR gender LIKE ? OR designation LIKE ?)';

    $param_types .= str_repeat('s', 4);

    $param_values = array_merge($param_values, array_fill(0, 4, '%' . $post['search']['value'] . '%'));
}

$sql .= sprintf(' WHERE %s', $where);

$allowed_columns = ['id', 'full_name', 'email', 'gender', 'designation'];

if (!empty($post['order'][0]['name'])
    && in_array($post['order'][0]['name'], $allowed_columns, true)) {
    $sql .= sprintf(' ORDER BY %s %s',
        $post['order'][0]['name'],
        $post['order'][0]['dir'] === 'desc' ? 'DESC' : 'ASC');
} else {
    $sql .= ' ORDER BY id DESC';
}

if ($post['length'] != -1) {
    $sql .= ' LIMIT ?, ?';

    $param_types .= 'ii';

    $param_values[] = intval($post['start']);
    $param_values[] = intval($post['length']);
}

$db_connection = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME) or die(mysqli_connect_error());

$stmt = mysqli_prepare($db_connection, $sql);
mysqli_stmt_bind_param($stmt, $param_types, ...$param_values);
mysqli_stmt_execute($stmt);

$result = mysqli_stmt_get_result($stmt);
mysqli_stmt_close($stmt);

$stmt = mysqli_prepare($db_connection, sprintf('SELECT COUNT(*) AS num_rows FROM employees WHERE %s', $where));

if (count($param_values) > 4) {
    mysqli_stmt_bind_param($stmt, substr($param_types, 0, 4), ...array_slice($param_values, 0, 4));
}

mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $filtered_rows);
mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);

$total_rows = mysqli_fetch_object(mysqli_query($db_connection, 'SELECT COUNT(*) AS num_rows FROM employees'))->num_rows;

$rows = [];

while ($employee = mysqli_fetch_assoc($result)) {
    $row = [];

    $row[] = $employee['id'];
    $row[] = $employee['full_name'];
    $row[] = $employee['email'];
    $row[] = $employee['gender'];
    $row[] = $employee['designation'];
    $row[] = '<a href="#">View</a>';

    $rows[] = $row;
}

$records = [];
$records['data'] = $rows;
$records['recordsTotal'] = intval($total_rows);
$records['recordsFiltered'] = intval($filtered_rows);

echo json_encode($records, JSON_PRETTY_PRINT);