<?php
$length = 32;

$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
?>
<!DOCTYPE html>
<html>
    <head>
        <title>Generate Random String in PHP - Demo</title>
        <meta content="text/html; charset=UTF-8" http-equiv="Content-Type"/>
        <meta content="width=device-width, initial-scale=1, maximum-scale=1" name="viewport" />
        <link rel="stylesheet" href="css/style.css" />
    </head>
    <body>
        <section class="section py-4">
            <div class="container">
                <div class="mb-4">
                    <h3>Method 1: Using substr() with str_shuffle()</h3>
                    <div>
                        <?=substr(str_shuffle($characters), 0, $length);?>
                    </div>
                </div>
                <div class="mb-4">
                    <h3>Method 2: Using bin2hex() with random_bytes()</h3>
                    <div>
                        <?=bin2hex(random_bytes($length / 2));?>
                    </div>
                </div>
                <div class="mb-4">
                    <h3>Method 3: Using bin2hex() with openssl_random_pseudo_bytes()</h3>
                    <div>
                        <?=substr(bin2hex(openssl_random_pseudo_bytes($length)), 0, $length);?>
                    </div>
                </div>
                <div class="mb-4">
                    <h3>Method 4: Using rand() with sha1() hashing</h3>
                    <div>
                        <?=substr(sha1(rand()), 0, $length);?>
                    </div>
                </div>
                <div class="mb-4">
                    <h3>Method 5: Using custom random characters</h3>
                    <div>
                        <?php
                        $random_string = '';

                        for ($i = 0; $i < $length; $i++) {
                            $random_string .= $characters[random_int(0, strlen($characters) - 1)];
                        }
                        ?>
                        <?=$random_string;?>
                    </div>
                </div>
            </div>
        </section>
    </body>
</html>