<?php
if (!session_id()) {
    session_start();
}
?>
<!DOCTYPE html>
<html>
    <head>
        <title>Add Event to Google Calendar in PHP - Demo</title>
        <meta content="text/html; charset=UTF-8" http-equiv="Content-Type"/>
        <meta content="width=device-width, initial-scale=1, maximum-scale=1" name="viewport"/>
        <link rel="stylesheet" href="css/style.css"/>
    </head>
    <body>
        <section class="section py-4">
            <div class="container">
                <?php if (!empty($_SESSION['success'])) { ?>
                    <div class="alert alert-green">
                        Event added successfully.
                    </div>
                    <?php unset($_SESSION['success']); ?>
                <?php } ?>

                <div class="mb-4">
                    <form action="google-calendar-events.php" method="POST" class="form-google-calendar-event">
                        <div class="mb-4">
                            <label class="inline-block mb-1">Calendar ID <span class="text-red">*</span></label>
                            <input type="text" name="calendar_id" class="form-control" placeholder="Calendar ID..."/>
                        </div>
                        <div class="mb-4">
                            <label class="inline-block mb-1">Summary <span class="text-red">*</span></label>
                            <input type="text" name="summary" class="form-control" placeholder="Event summary..."/>
                        </div>
                        <div class="mb-4">
                            <label class="inline-block mb-1">Location <span class="text-red">*</span></label>
                            <input type="text" name="location" class="form-control" placeholder="Event location..."/>
                        </div>
                        <div class="mb-4">
                            <label class="inline-block mb-1">Description <span class="text-red">*</span></label>
                            <input type="text" name="description" class="form-control" placeholder="Event description..."/>
                        </div>
                        <div class="mb-4">
                            <label class="inline-block mb-1">Start <span class="text-red">*</span></label>
                            <input type="datetime-local" name="start" class="form-control"
                                   placeholder="Event start date and time..."/>
                        </div>
                        <div class="mb-4">
                            <label class="inline-block mb-1">End <span class="text-red">*</span></label>
                            <input type="datetime-local" name="end" class="form-control"
                                   placeholder="Event end date and time..."/>
                        </div>
                        <div class="mb-4">
                            <button type="submit" class="btn btn-blue">Add Event</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </body>
</html>