<?php
include_once __DIR__ . '/vendor/autoload.php';

if (!session_id()) {
    session_start();
}

$post = filter_input_array(INPUT_POST);

// Initialize google client instance
$client = new Google_Client();

// Set service account config
$client->setAuthConfig('PATH_TO_SERVICE_ACCOUNT_CREDENTIALS');

// Set google calendar scope
$client->setScopes(Google_Service_Calendar::CALENDAR);

// Initialize google calendar service
$calendar_service = new Google_Service_Calendar($client);

date_default_timezone_set('America/Los_Angeles');

$start_date_time = date('Y-m-d\TH:i:s', strtotime($post['start']));
$end_date_time = date('Y-m-d\TH:i:s', strtotime($post['end']));
$timezone_offset = date('P');

// Create google calendar event
$event = new Google_Service_Calendar_Event([
    'summary' => $post['summary'],
    'location' => $post['location'],
    'description' => $post['description'],
    'start' => ['dateTime' => sprintf('%s%s', $start_date_time, $timezone_offset)],
    'end' => ['dateTime' => sprintf('%s%s', $end_date_time, $timezone_offset)],
]);

$calendar_service->events->insert($post['calendar_id'], $event);

$_SESSION['success'] = true;

// Redirect user
header('Location: ' . filter_var($_SERVER['HTTP_REFERER'], FILTER_SANITIZE_URL));
exit;